/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class Timezone {
    private final TimeZone mNativeZone = TimeZone.getDefault();
    private static Timezone s_local_zone;

    public static Timezone getLocalZone() {
        Timezone zone = s_local_zone;
        if (zone == null) {
            s_local_zone = zone = new Timezone();
        }
        return zone;
    }

    public String format(Timestamp time) {
        Calendar cale = Calendar.getInstance(this._nativeZone());
        cale.setTimeInMillis(time.milliseconds());
        int yy = cale.get(1);
        int mm = cale.get(2) + 1;
        int dd = cale.get(5);
        int h = cale.get(11);
        int m = cale.get(12);
        int s = cale.get(13);
        String strY = "" + yy;
        String strM = "" + mm;
        String strD = "" + dd;
        String strh = String.valueOf(h);
        String strm = String.valueOf(m);
        String strs = String.valueOf(s);
        if (strY.length() < 2) {
            strY = "0" + strY;
        }
        if (strM.length() < 2) {
            strM = "0" + strM;
        }
        if (strD.length() < 2) {
            strD = "0" + strD;
        }
        if (strh.length() < 2) {
            strh = "0" + strh;
        }
        if (strm.length() < 2) {
            strm = "0" + strm;
        }
        if (strs.length() < 2) {
            strs = "0" + strs;
        }
        return String.valueOf(strY) + "-" + strM + "-" + strD + " " + strh + ":" + strm + ":" + strs;
    }

    private TimeZone _nativeZone() {
        return this.mNativeZone;
    }

    public String formatTimePart(Timestamp time) {
        Calendar cale = Calendar.getInstance(this._nativeZone());
        cale.setTimeInMillis(time.milliseconds());
        int h = cale.get(11);
        int m = cale.get(12);
        int s = cale.get(13);
        String strh = String.valueOf(h);
        String strm = String.valueOf(m);
        String strs = String.valueOf(s);
        if (strh.length() < 2) {
            strh = "0" + strh;
        }
        if (strm.length() < 2) {
            strm = "0" + strm;
        }
        if (strs.length() < 2) {
            strs = "0" + strs;
        }
        return String.valueOf(strh) + ":" + strm + ":" + strs;
    }

    public String formatDatePart(Timestamp time) {
        Calendar cale = Calendar.getInstance(this._nativeZone());
        cale.setTimeInMillis(time.milliseconds());
        int yy = cale.get(1);
        int mm = cale.get(2) + 1;
        int dd = cale.get(5);
        String strY = "" + yy;
        String strM = "" + mm;
        String strD = "" + dd;
        if (strY.length() < 2) {
            strY = "0" + strY;
        }
        if (strM.length() < 2) {
            strM = "0" + strM;
        }
        if (strD.length() < 2) {
            strD = "0" + strD;
        }
        return String.valueOf(strY) + "-" + strM + "-" + strD;
    }
}

