/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.DefaultThermoResult;
import ananas.cust.app.ir_therm.core.IDocumentIO;
import ananas.cust.app.ir_therm.core.IDocumentIOFactory;
import ananas.cust.app.ir_therm.core.SampleRate;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureC;
import ananas.cust.app.ir_therm.core.TemperatureF;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timestamp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TheTextDocIOFactory
implements IDocumentIOFactory {
    private static final String CRLF = "\r\n";

    @Override
    public IDocumentIO newIO() {
        return new MyIO();
    }

    @Override
    public String getDefaultExtendsName() {
        return "txt";
    }

    private class AbstractTextFile {
        String header;
        Map<String, String> properties;
        List<String> items;

        private AbstractTextFile() {
        }

        public boolean load(File file2) {
            InputStream in;
            boolean success;
            block13: {
                System.out.println("load from text file " + file2);
                success = false;
                in = null;
                if (file2.exists()) break block13;
                return false;
            }
            try {
                in = new FileInputStream(file2);
                InputStreamReader rdr = new InputStreamReader(in, "UTF-8");
                HashMap<String, String> map = new HashMap<String, String>();
                ArrayList<String> list = new ArrayList<String>();
                StringBuilder sb = new StringBuilder();
                int iline = 0;
                int cnt0d = 0;
                int cnt0a = 0;
                boolean inbody = false;
                while (true) {
                    int il;
                    boolean lineEnd = false;
                    int ch = rdr.read();
                    if (ch < 0) break;
                    if (ch == 13) {
                        ++cnt0d;
                        lineEnd = true;
                    } else if (ch == 10) {
                        ++cnt0a;
                        lineEnd = true;
                    } else {
                        sb.append((char)ch);
                    }
                    if (!lineEnd || (il = Math.max(cnt0a, cnt0d)) == iline) continue;
                    int i = iline;
                    iline = il;
                    String line = sb.toString();
                    sb.setLength(0);
                    if (inbody) {
                        list.add(line);
                        continue;
                    }
                    if (i == 0) {
                        this.header = line;
                        continue;
                    }
                    if (line.isEmpty()) {
                        inbody = true;
                        continue;
                    }
                    int n = line.indexOf(58);
                    if (n < 0) continue;
                    String key = line.substring(0, n);
                    String val = line.substring(n + 1);
                    map.put(key, val);
                }
                this.items = list;
                this.properties = map;
                success = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return success;
        }

        public boolean save(File file2) {
            System.out.println("save to text file " + file2);
            boolean success = false;
            OutputStream os = null;
            try {
                if (!file2.exists()) {
                    file2.getParentFile().mkdirs();
                    file2.createNewFile();
                }
                os = new FileOutputStream(file2);
                OutputStreamWriter wtr = new OutputStreamWriter(os, "UTF-8");
                wtr.write(String.valueOf(this.header) + TheTextDocIOFactory.CRLF);
                Map<String, String> map = this.properties;
                if (map != null) {
                    Set<String> keys = map.keySet();
                    for (String key : keys) {
                        String val = map.get(key);
                        wtr.write(String.valueOf(key) + ":" + val + TheTextDocIOFactory.CRLF);
                    }
                }
                wtr.write(TheTextDocIOFactory.CRLF);
                List<String> list = this.items;
                for (String item : list) {
                    wtr.write(String.valueOf(item) + TheTextDocIOFactory.CRLF);
                }
                wtr.flush();
                os.flush();
                success = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return success;
        }
    }

    private class Keys {
        public static final String property_fields = "Fields";
        public static final String property_version = "Version";
        public static final String property_unit = "Temperature-Unit";
        public static final String property_alarm_low = "Alarm-Low";
        public static final String property_alarm_high = "Alarm-High";
        public static final String property_sample_rate = "Sample-Rate";
        public static final String field_index = "INDEX";
        public static final String field_timestamp = "TIMESTAMP";
        public static final String field_temperature = "TEMPERATURE";
        public static final String field_unit = "UNIT";

        private Keys() {
        }
    }

    private class MyIO
    implements IDocumentIO {
        private MyIO() {
        }

        @Override
        public IDocumentIO.MainDocData loadMain(File file2) {
            MyMainDoc doc = new MyMainDoc();
            doc.data = null;
            doc.load(file2);
            return doc.data;
        }

        @Override
        public IDocumentIO.SubDocData loadSub(File file2) {
            MySubDoc doc = new MySubDoc();
            doc.data = null;
            doc.load(file2);
            return doc.data;
        }

        @Override
        public boolean save(File file2, IDocumentIO.MainDocData mdd) {
            MyMainDoc doc = new MyMainDoc();
            doc.data = mdd;
            return doc.save(file2);
        }

        @Override
        public boolean save(File file2, IDocumentIO.SubDocData sdd) {
            MySubDoc doc = new MySubDoc();
            doc.data = sdd;
            return doc.save(file2);
        }
    }

    private class MyMainDoc
    extends AbstractTextFile {
        IDocumentIO.MainDocData data;
        static final String header_prefix = "IRTTMD,";

        private MyMainDoc() {
        }

        @Override
        public boolean load(File file2) {
            boolean rlt = super.load(file2);
            if (!rlt) {
                return false;
            }
            IDocumentIO.MainDocData mdd = new IDocumentIO.MainDocData();
            Vector<File> destList = new Vector<File>();
            List srcList = this.items;
            File dir = file2.getParentFile();
            for (String s : srcList) {
                if ((s = s.trim()).length() <= 0) continue;
                while (s.startsWith("/") || s.startsWith("\\")) {
                    s = s.substring(1);
                }
                File f2 = new File(dir, s);
                destList.add(f2);
            }
            mdd.mainDoc = file2;
            mdd.subDocList = destList;
            Map prop = this.properties;
            mdd.sampleRate = SampleRate.parse((String)prop.get("Sample-Rate"));
            mdd.alarmH = Temperature.parse((String)prop.get("Alarm-High"));
            mdd.alarmL = Temperature.parse((String)prop.get("Alarm-Low"));
            mdd.unit = TemperatureUnit.Factory.parse((String)prop.get("Temperature-Unit"));
            this.data = mdd;
            return rlt;
        }

        @Override
        public boolean save(File file2) {
            this.header = "IRTTMD,IR Thermometer Text Main Document";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Version", "1.0");
            map.put("Sample-Rate", "" + this.data.sampleRate);
            map.put("Alarm-High", "" + this.data.alarmH);
            map.put("Alarm-Low", "" + this.data.alarmL);
            map.put("Temperature-Unit", "" + this.data.unit);
            this.properties = map;
            List<File> sdl = this.data.subDocList;
            ArrayList<String> list = new ArrayList<String>();
            String base = this.data.mainDoc.getParent();
            for (File sd : sdl) {
                String full = sd.getAbsolutePath();
                String path = full.substring(base.length());
                while (path.startsWith("/") || path.startsWith("\\")) {
                    path = path.substring(1);
                }
                list.add(path);
            }
            this.items = list;
            return super.save(file2);
        }
    }

    private class MySubDoc
    extends AbstractTextFile {
        IDocumentIO.SubDocData data;
        private final List<String> mFieldsDataList = new ArrayList<String>();
        private final StringBuilder mFieldsDataBuffer = new StringBuilder();
        static final String sub_fields = "INDEX,TIMESTAMP,TEMPERATURE,UNIT";
        static final String header_prefix = "IRTTSD,";

        private MySubDoc() {
        }

        @Override
        public boolean load(File file2) {
            boolean rlt = super.load(file2);
            if (!rlt) {
                return false;
            }
            List src = this.items;
            IDocumentIO.SubDocData sdd = new IDocumentIO.SubDocData();
            Vector<ThermoResult> dest = new Vector<ThermoResult>();
            for (String s : src) {
                ThermoResult item = this._parseItem(s);
                if (item == null) continue;
                dest.add(item);
            }
            sdd.sampleList = dest;
            this.data = sdd;
            return true;
        }

        private ThermoResult _parseItem(String s) {
            List<String> f = this._parseItemToFields(s);
            int index = Integer.parseInt(f.get(0).trim());
            Timestamp time = this._parseTimestamp(f.get(1));
            Temperature temper = this._parseTemper(f.get(2), f.get(3));
            return new DefaultThermoResult(index, time, temper);
        }

        private Temperature _parseTemper(String value, String unit) {
            double dv = Double.parseDouble(value.trim());
            if (unit.contains("F")) {
                return new TemperatureF(dv);
            }
            return new TemperatureC(dv);
        }

        private Timestamp _parseTimestamp(String string) {
            long lv = Long.parseLong(string.trim());
            return new Timestamp(lv);
        }

        private List<String> _parseItemToFields(String s) {
            char[] chs;
            StringBuilder sb = this.mFieldsDataBuffer;
            List<String> list = this.mFieldsDataList;
            list.clear();
            sb.setLength(0);
            char[] cArray = chs = s.toCharArray();
            int n = chs.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == ',') {
                    list.add(sb.toString());
                    sb.setLength(0);
                } else {
                    sb.append(ch);
                }
                ++n2;
            }
            if (sb.length() > 0) {
                list.add(sb.toString());
            }
            return list;
        }

        @Override
        public boolean save(File file2) {
            this.header = "IRTTSD,IR Thermometer Text Sub Document";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Version", "1.0");
            map.put("Fields", sub_fields);
            this.properties = map;
            List<ThermoResult> sl = this.data.sampleList;
            ArrayList<String> list = new ArrayList<String>();
            for (ThermoResult sample : sl) {
                long ms = sample.getTimestamp().milliseconds();
                int index = sample.getIndex();
                Temperature temp = sample.getTemperature();
                String val = temp.getValueString();
                String unit = temp.getUnit().toString();
                list.add(String.valueOf(index) + "," + ms + "," + val + "," + unit);
            }
            this.items = list;
            return super.save(file2);
        }
    }
}

