/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureC;
import ananas.cust.app.ir_therm.core.TemperatureF;

public interface TemperatureUnit {
    public static final TemperatureUnit unit_a = Factory._new('A');
    public static final TemperatureUnit unit_c = Factory._new('C');
    public static final TemperatureUnit unit_f = Factory._new('F');

    public Temperature convert(Temperature var1);

    public char charValue();

    public Temperature objectForValue(double var1);

    public static class Factory {
        public static TemperatureUnit _new(char ch) {
            return new MyImpl(ch);
        }

        public static TemperatureUnit parse(String string) {
            if (string != null && string.contains("F")) {
                return unit_f;
            }
            return unit_c;
        }

        static class MyImpl
        implements TemperatureUnit {
            private final String mChStr;
            private final char mCh;

            public MyImpl(char ch) {
                this.mChStr = "\u00b0" + ch;
                this.mCh = ch;
            }

            public String toString() {
                return this.mChStr;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof TemperatureUnit)) {
                    return false;
                }
                TemperatureUnit b = (TemperatureUnit)obj;
                MyImpl a = this;
                return a.charValue() == b.charValue();
            }

            @Override
            public Temperature convert(Temperature temp) {
                MyImpl u2 = this;
                TemperatureUnit u1 = temp.getUnit();
                if (u1.equals(u2)) {
                    return temp;
                }
                if (((Object)u2).equals(unit_c)) {
                    double f = temp.getValue();
                    double c = (f - 32.0) / 1.8;
                    return new TemperatureC(c);
                }
                double c = temp.getValue();
                double f = 1.8 * c + 32.0;
                return new TemperatureF(f);
            }

            @Override
            public Temperature objectForValue(double value) {
                char ch = this.mCh;
                switch (ch) {
                    case 'F': {
                        return new TemperatureF(value);
                    }
                }
                return new TemperatureC(value);
            }

            @Override
            public char charValue() {
                return this.mCh;
            }
        }
    }
}

