/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.TemperatureC;
import ananas.cust.app.ir_therm.core.TemperatureF;
import ananas.cust.app.ir_therm.core.TemperatureUnit;

public abstract class Temperature {
    private final double value;

    public abstract TemperatureUnit getUnit();

    public String getValueString() {
        double v = this.value;
        String str = Double.toString(v);
        int i = str.indexOf(46);
        if (i > 0) {
            if (-1000.0 < v && v < 1000.0) {
                return (String.valueOf(str) + "000").substring(0, i + 2);
            }
            return str.substring(0, i);
        }
        return str;
    }

    public Temperature(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        String v = this.getValueString();
        String unit = this.getUnit().toString();
        return String.valueOf(v) + unit;
    }

    public static Temperature parse(String string) {
        char[] chs;
        if (string == null) {
            return new TemperatureC(0.0);
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = chs = string.trim().toCharArray();
        int n = chs.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if ('0' <= ch && ch <= '9') {
                sb.append(ch);
            } else {
                if (ch != '.' && ch != '-') break;
                sb.append(ch);
            }
            ++n2;
        }
        String num = sb.toString();
        if (string.contains("F")) {
            return new TemperatureF(Double.parseDouble(num));
        }
        return new TemperatureC(Double.parseDouble(num));
    }
}

