/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.DefaultThermoResult;
import ananas.cust.app.ir_therm.core.IContext;
import ananas.cust.app.ir_therm.core.IThermo;
import ananas.cust.app.ir_therm.core.IThermoFactory;
import ananas.cust.app.ir_therm.core.SampleRate;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureC;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.event.ThermoResultEvent;
import ananas.cust.app.ir_therm.event.ThermoStatusEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ShellThermoFactory
implements IThermoFactory {
    @Override
    public IThermo newThermo(IContext context) {
        return new MyThermo(context);
    }

    static interface Err {
        public static final int success = 0;
        public static final int bad_data = 4;
    }

    class MyDaemon
    implements Runnable {
        private MyResultListener mResultListener;
        private double mLastUsefulTempe;

        MyDaemon() {
        }

        @Override
        public void run() {
            try {
                this._unsafe_run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setResultListener(MyResultListener rl) {
            this.mResultListener = new MyErrorFilter(rl);
        }

        private void _unsafe_run() throws IOException {
            InputStream in = System.in;
            byte[] buff = new byte[128];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (true) {
                this._safe_sleep(10);
                int cb = in.read(buff);
                int i = 0;
                while (i < cb) {
                    byte b = buff[i];
                    if (b == 10 || b == 13) {
                        byte[] ba = baos.toByteArray();
                        baos.reset();
                        String str = new String(ba, "UTF-8");
                        this.onLine(str);
                    } else {
                        baos.write(b);
                    }
                    ++i;
                }
                if (baos.size() <= 512) continue;
                baos.reset();
            }
        }

        private void onLine(String str) {
            try {
                if (str != null && !str.startsWith("$ERROR,") && !str.startsWith("$DATA,") && !str.startsWith("$DATAv2,") && str.startsWith("$DATAv3,")) {
                    this.onDataV3(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void onDataV3(String str) {
            String[] fields = this.getFields(str);
            if (!fields[0].equals("$DATAv3")) {
                throw new RuntimeException("not a $DATAv3 line.");
            }
            int index = Integer.parseInt(fields[1]);
            long time = Long.parseLong(fields[2]);
            String data = fields[3];
            int status = Integer.parseInt(fields[4]);
            double minReturnValue = -1000000.0;
            double tempe = -1000000.0;
            String err = null;
            switch (status) {
                case 0: {
                    tempe = this.getTempeCFromString(data, -1000010.0, 16);
                    if (tempe > -1000000.0) {
                        this.mLastUsefulTempe = tempe;
                        break;
                    }
                    tempe = this.mLastUsefulTempe;
                    break;
                }
                case 4: {
                    tempe = this.mLastUsefulTempe;
                    break;
                }
                default: {
                    tempe = this.mLastUsefulTempe;
                    err = "error";
                }
            }
            TemperatureC _tempe = new TemperatureC(tempe);
            Timestamp _time = Timestamp.getTimestamp(time);
            DefaultThermoResult rlt = new DefaultThermoResult(index, _time, _tempe);
            this.mResultListener.onResult(rlt, err);
        }

        private String[] getFields(String str) {
            ArrayList<String> list = new ArrayList<String>();
            int from = 0;
            while (true) {
                int mark;
                if ((mark = str.indexOf(44, from)) < 0) break;
                list.add(str.substring(from, mark).trim());
                from = mark + 1;
            }
            list.add(str.substring(from).trim());
            return list.toArray(new String[list.size()]);
        }

        private void onDataV2(String str) {
            int i0 = str.indexOf(44);
            if (i0 < 0) {
                return;
            }
            int i1 = str.indexOf(44, i0 + 1);
            if (i1 < 0) {
                return;
            }
            int i2 = str.indexOf(44, i1 + 1);
            if (i2 < 0) {
                return;
            }
            String index = str.substring(i0 + 1, i1).trim();
            String time = str.substring(i1 + 1, i2).trim();
            double minReturnValue = -100000.0;
            String strData = str.substring(i2 + 1);
            double temper_c = this.getTempeCFromString(strData, -100001.0, 12);
            TemperatureC tempe = new TemperatureC(temper_c);
            MyDefaultResult rlt = new MyDefaultResult();
            rlt.mIndex = Integer.parseInt(index);
            rlt.mTime = Timestamp.getTimestamp(Long.parseLong(time));
            rlt.mTempe = tempe;
            if (-100000.0 < temper_c) {
                this.mResultListener.onResult(rlt, null);
            } else {
                this.mResultListener.onResult(rlt, "bad data");
            }
        }

        private double getTempeCFromString(String str, double minReturnValue, int cbMax) {
            int b3 = 0;
            int b2 = 0;
            int b1 = 0;
            int b0 = 0;
            char[] chs = str.toCharArray();
            MyDataReader rdr = new MyDataReader(chs, 0, chs.length);
            int i = 0;
            while (i < cbMax) {
                int b = rdr.readByte();
                if (b < 0) break;
                b0 = b1;
                b1 = b2;
                b2 = b3;
                b3 = b & 0xFF;
                if ((b0 & 0xF0) == 128 && (b1 & 0xF0) == 144 && (b2 & 0xF0) == 160 && (b3 & 0xF0) == 176) {
                    int n = 0;
                    n |= b0 << 12 & 0xF000;
                    n |= b1 << 8 & 0xF00;
                    n |= b2 << 4 & 0xF0;
                    short sn = (short)(n |= b3 << 0 & 0xF);
                    n = sn;
                    double dn = (double)n / 10.0;
                    return dn;
                }
                ++i;
            }
            return minReturnValue;
        }

        private void _safe_sleep(int ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class MyDataReader {
        private final char[] mChs;
        private final int mOffset;
        private final int mLength;
        private final int mEndPos;
        private int mPtr;

        public MyDataReader(char[] chs, int offset, int length) {
            this.mChs = chs;
            this.mOffset = offset;
            this.mLength = length;
            this.mEndPos = offset + length;
            this.mPtr = offset;
        }

        public int readByte() {
            int i0 = this.indexOfByte(true, this.mPtr);
            if (i0 < 0) {
                return -1;
            }
            int i1 = this.indexOfByte(false, i0);
            if (i1 < 0) {
                return -1;
            }
            this.mPtr = i1;
            String s = new String(this.mChs, i0, i1 - i0);
            return Integer.parseInt(s, 16);
        }

        private int indexOfByte(boolean isByte, int index) {
            int i = index;
            while (i < this.mEndPos) {
                char ch = this.mChs[i];
                boolean inb = '0' <= ch && ch <= '9' ? true : ('a' <= ch && ch <= 'f' ? true : 'A' <= ch && ch <= 'F');
                if (inb ? isByte : !isByte) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    class MyDefaultResult
    implements ThermoResult {
        private int mIndex;
        private Timestamp mTime;
        private Temperature mTempe;

        MyDefaultResult() {
        }

        @Override
        public int getIndex() {
            return this.mIndex;
        }

        @Override
        public Timestamp getTimestamp() {
            if (this.mTime == null) {
                this.mTime = Timestamp.getTimestampNow();
            }
            return this.mTime;
        }

        @Override
        public Temperature getTemperature() {
            if (this.mTempe == null) {
                this.mTempe = new TemperatureC(0.0);
            }
            return this.mTempe;
        }
    }

    class MyErrorFilter
    implements MyResultListener {
        private final MyResultListener target;

        public MyErrorFilter(MyResultListener rl) {
            this.target = rl;
        }

        @Override
        public void onResult(ThermoResult rlt, String err) {
            this.target.onResult(rlt, err);
        }
    }

    static interface MyResultListener {
        public void onResult(ThermoResult var1, String var2);
    }

    class MyThermo
    implements IThermo,
    MyResultListener {
        private ThermoResult mCurResult;
        private final IContext mContext;
        private MyDaemon mDaemon;
        private boolean mIsRunning;
        private boolean mIsError;

        public MyThermo(IContext context) {
            this.mContext = context;
            MyDaemon dm = new MyDaemon();
            MyThermo rl = this;
            dm.setResultListener(rl);
            this.mDaemon = dm;
            new Thread(dm).start();
        }

        @Override
        public void start() {
            this.mIsRunning = true;
            this.dispatchStatusEvent();
        }

        private void dispatchStatusEvent() {
            ThermoStatusEvent.Status status = this.mIsRunning ? (this.mIsError ? ThermoStatusEvent.status_error : ThermoStatusEvent.status_connected) : ThermoStatusEvent.status_disconnected;
            ThermoStatusEvent event = new ThermoStatusEvent(this, status);
            this.mContext.getEventDispatcher().dispatchEvent(event);
        }

        @Override
        public void restart() {
            this.mIsRunning = true;
            this.dispatchStatusEvent();
        }

        @Override
        public void stop() {
            this.mIsRunning = false;
            this.dispatchStatusEvent();
        }

        @Override
        public ThermoResult getCurrentResult() {
            ThermoResult rlt = this.mCurResult;
            if (rlt == null) {
                this.mCurResult = rlt = this._defaultResult();
            }
            return rlt;
        }

        private ThermoResult _defaultResult() {
            MyDefaultResult rlt = new MyDefaultResult();
            return rlt;
        }

        @Override
        public void setSampleRate(SampleRate rate) {
        }

        @Override
        public void openHelpContent() {
        }

        @Override
        public void onResult(ThermoResult rlt, String err) {
            boolean isErr;
            if (!this.mIsRunning) {
                return;
            }
            boolean bl = isErr = err != null;
            if (!isErr) {
                this.mCurResult = rlt;
                ThermoResultEvent event = new ThermoResultEvent(this, rlt);
                this.mContext.getEventDispatcher().dispatchEvent(event);
            }
            this.mIsError = isErr;
            this.dispatchStatusEvent();
        }
    }
}

