/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

public class SampleRate {
    private final int mTimeInterval;

    public SampleRate(int ms) {
        this.mTimeInterval = ms;
    }

    public String toString() {
        int ms = this.mTimeInterval;
        if (ms < 1000) {
            return String.valueOf(ms) + " ms";
        }
        return String.valueOf(ms / 1000) + " s";
    }

    public int getValue() {
        return this.mTimeInterval;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SampleRate)) {
            return false;
        }
        SampleRate b = (SampleRate)obj;
        SampleRate a = this;
        return a.getValue() == b.getValue();
    }

    public static SampleRate parse(String string) {
        char[] chs;
        if (string == null) {
            return new SampleRate(1000);
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = chs = string.trim().toCharArray();
        int n = chs.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if ('0' > ch || ch > '9') break;
            sb.append(ch);
            ++n2;
        }
        String num = sb.toString();
        if (string.contains("ms")) {
            return new SampleRate(Integer.parseInt(num));
        }
        return new SampleRate(Integer.parseInt(num) * 1000);
    }
}

