/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.IDocumentIO;
import ananas.cust.app.ir_therm.core.IDocumentIOFactory;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.core.Timezone;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class DefaultXlsDocIOFactory
implements IDocumentIOFactory {
    @Override
    public IDocumentIO newIO() {
        return new MyIO();
    }

    @Override
    public String getDefaultExtendsName() {
        return "xls";
    }

    class MyIO
    implements IDocumentIO {
        MyIO() {
        }

        @Override
        public IDocumentIO.MainDocData loadMain(File file2) {
            return null;
        }

        @Override
        public IDocumentIO.SubDocData loadSub(File file2) {
            return null;
        }

        @Override
        public boolean save(File file2, IDocumentIO.MainDocData mdd) {
            return false;
        }

        @Override
        public boolean save(File file2, IDocumentIO.SubDocData sdd) {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(file2.getName());
            int rownum = 0;
            HSSFRow rowStartTime = sheet.createRow(rownum++);
            HSSFRow rowEndTime = sheet.createRow(rownum++);
            HSSFRow rowMax = sheet.createRow(rownum++);
            HSSFRow rowMin = sheet.createRow(rownum++);
            HSSFRow rowSampleRate = sheet.createRow(rownum++);
            HSSFRow rowDataNumber = sheet.createRow(rownum++);
            HSSFRow rowAverage = sheet.createRow(rownum++);
            HSSFRow rowHighAlarm = sheet.createRow(rownum++);
            HSSFRow rowLowAlarm = sheet.createRow(rownum++);
            HSSFRow rowUnit = sheet.createRow(rownum++);
            sheet.createRow(rownum++);
            int col_num = 0;
            HSSFRow row = sheet.createRow(rownum++);
            row.createCell(col_num++).setCellValue("INDEX");
            row.createCell(col_num++).setCellValue("VALUE");
            row.createCell(col_num++).setCellValue("UNIT");
            row.createCell(col_num++).setCellValue("DATE");
            row.createCell(col_num++).setCellValue("TIME");
            MyResultsCounter rc = new MyResultsCounter();
            for (ThermoResult sample : sdd.sampleList) {
                int index = sample.getIndex();
                double value = sample.getTemperature().getValue();
                String unit = sample.getTemperature().getUnit().toString();
                String date = this.toDateString(sample.getTimestamp());
                String time = this.toTimeString(sample.getTimestamp());
                rc.append(sample);
                row = sheet.createRow(rownum++);
                col_num = 0;
                row.createCell(col_num++).setCellValue(index);
                row.createCell(col_num++).setCellValue(value);
                row.createCell(col_num++).setCellValue(unit);
                row.createCell(col_num++).setCellValue(date);
                row.createCell(col_num++).setCellValue(time);
            }
            this.setKeyValueRow(rowUnit, "Unit", sdd.unit.toString());
            this.setKeyValueRow(rowSampleRate, "Sample Rate", String.valueOf(sdd.sampleRate.getValue() / 1000) + "s");
            this.setKeyValueRow(rowHighAlarm, "High Alarm", sdd.alarmH.toString());
            this.setKeyValueRow(rowLowAlarm, "Low Alarm", sdd.alarmL.toString());
            this.setKeyValueRow(rowDataNumber, "Data Number", String.valueOf(sdd.sampleList.size()));
            this.setKeyValueRow(rowStartTime, "Start Time", rc.stringStartTime());
            this.setKeyValueRow(rowEndTime, "End Time", rc.stringEndTime());
            this.setKeyValueRow(rowAverage, "Average", rc.stringAverage());
            this.setKeyValueRow(rowMax, "Max", rc.stringMaxItem());
            this.setKeyValueRow(rowMin, "Min", rc.stringMinItem());
            try {
                file2.getParentFile().mkdirs();
                file2.createNewFile();
                FileOutputStream out = new FileOutputStream(file2);
                wb.write(out);
                out.close();
                return true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }

        private void setKeyValueRow(HSSFRow rowUnit, String key, String value) {
            int col_num = 0;
            HSSFCell row0 = rowUnit.createCell(col_num++);
            row0.setCellValue(key);
            HSSFCell row1 = rowUnit.createCell(col_num++);
            row1.setCellValue(value);
        }

        private String toTimeString(Timestamp time) {
            return Timezone.getLocalZone().formatTimePart(time);
        }

        private String toDateString(Timestamp time) {
            return Timezone.getLocalZone().formatDatePart(time);
        }
    }

    class MyResultsCounter {
        double mMaxValue;
        double mMinValue;
        double mAverageSigma;
        int mAverageCount;
        ThermoResult mMaxItem;
        ThermoResult mMinItem;
        ThermoResult mLastItem;
        ThermoResult mFirstItem;
        private final TemperatureUnit mUnit = TemperatureUnit.unit_c;

        public MyResultsCounter() {
            this.reset();
        }

        public String stringMinItem() {
            ThermoResult item = this.mMinItem;
            if (item == null) {
                return "-";
            }
            Temperature tempe = this.mUnit.convert(item.getTemperature());
            String time = Timezone.getLocalZone().format(item.getTimestamp());
            return String.valueOf(tempe.toString()) + "    " + time;
        }

        public String stringMaxItem() {
            ThermoResult item = this.mMaxItem;
            if (item == null) {
                return "-";
            }
            Temperature tempe = this.mUnit.convert(item.getTemperature());
            String time = Timezone.getLocalZone().format(item.getTimestamp());
            return String.valueOf(tempe.toString()) + "    " + time;
        }

        public String stringAverage() {
            int cnt = this.mAverageCount;
            if (cnt > 0) {
                double value = this.mAverageSigma / (double)cnt;
                Temperature tempe = this.mUnit.objectForValue(value);
                return tempe.toString();
            }
            return "-";
        }

        public String stringEndTime() {
            ThermoResult item = this.mLastItem;
            if (item != null) {
                return Timezone.getLocalZone().format(item.getTimestamp());
            }
            return "-";
        }

        public String stringStartTime() {
            ThermoResult item = this.mFirstItem;
            if (item != null) {
                return Timezone.getLocalZone().format(item.getTimestamp());
            }
            return "-";
        }

        private void reset() {
            this.mFirstItem = null;
            this.mLastItem = null;
            this.mMaxItem = null;
            this.mMinItem = null;
            this.mMaxValue = Double.MIN_VALUE;
            this.mMinValue = Double.MAX_VALUE;
            this.mAverageSigma = 0.0;
            this.mAverageCount = 0;
        }

        public void append(ThermoResult sample) {
            if (this.mFirstItem == null) {
                this.mFirstItem = sample;
            }
            this.mLastItem = sample;
            Temperature tempe = this.mUnit.convert(sample.getTemperature());
            double value = tempe.getValue();
            this.mAverageSigma += value;
            ++this.mAverageCount;
            if (value > this.mMaxValue) {
                this.mMaxItem = sample;
                this.mMaxValue = value;
            }
            if (value < this.mMinValue) {
                this.mMinItem = sample;
                this.mMinValue = value;
            }
        }
    }
}

