/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.Const;
import ananas.cust.app.ir_therm.core.IContext;
import ananas.cust.app.ir_therm.core.IDocSettings;
import ananas.cust.app.ir_therm.core.SampleRate;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureC;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import java.awt.Color;

public class DefaultSettings
implements IDocSettings {
    private final IContext mContext;
    private TemperatureUnit mUnit = TemperatureUnit.unit_c;
    private int mBufferCap = Const.sub_buffer_size;
    private Temperature mHighAlarm = new TemperatureC(50.0);
    private Temperature mLowAlarm = new TemperatureC(-50.0);
    private SampleRate mSampleRate = new SampleRate(1000);
    private Color mColorLowAlarm = Color.blue;
    private Color mColorHighAlarm = Color.red;
    private Color mColorLineBg = Color.BLACK;
    private Color mColorLineFg = Color.white;
    private Color mGridColor = Color.gray;
    private boolean mAutoScroll = true;

    public DefaultSettings(IContext context) {
        this.mContext = context;
    }

    @Override
    public TemperatureUnit getUnit() {
        return this.mUnit;
    }

    @Override
    public Temperature getHighAlarm() {
        return this.mHighAlarm;
    }

    @Override
    public Temperature getLowAlarm() {
        return this.mLowAlarm;
    }

    @Override
    public SampleRate getSampleRate() {
        return this.mSampleRate;
    }

    @Override
    public boolean autoScroll() {
        return this.mAutoScroll;
    }

    @Override
    public int getBufferCap() {
        return this.mBufferCap;
    }

    @Override
    public void setLowAlarm(Temperature temperature) {
        if (temperature != null) {
            this.mLowAlarm = temperature;
        }
    }

    @Override
    public void setHighAlarm(Temperature temperature) {
        if (temperature != null) {
            this.mHighAlarm = temperature;
        }
    }

    @Override
    public void setUnit(TemperatureUnit unit) {
        if (unit != null) {
            this.mUnit = unit;
        }
    }

    @Override
    public void setSampleRate(SampleRate rate) {
        if (rate != null) {
            this.mSampleRate = rate;
        }
    }

    @Override
    public void copyFrom(IDocSettings settings) {
    }
}

