/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.DefaultDataBufferHolder;
import ananas.cust.app.ir_therm.core.DefaultSettings;
import ananas.cust.app.ir_therm.core.DefaultSubDocument;
import ananas.cust.app.ir_therm.core.DefaultThermoResult;
import ananas.cust.app.ir_therm.core.IContext;
import ananas.cust.app.ir_therm.core.IDataBuffer;
import ananas.cust.app.ir_therm.core.IDataBufferHolder;
import ananas.cust.app.ir_therm.core.IDocSettings;
import ananas.cust.app.ir_therm.core.IDocumentIO;
import ananas.cust.app.ir_therm.core.IDocumentIOFactory;
import ananas.cust.app.ir_therm.core.IMainDoc;
import ananas.cust.app.ir_therm.core.ISubDoc;
import ananas.cust.app.ir_therm.core.SampleRate;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.TheTextDocIOFactory;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timestamp;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DefaultMainDocument
implements IMainDoc {
    private final List<ISubDoc> mSubDocList = new Vector<ISubDoc>();
    private final IDocSettings mSettings;
    private boolean mRecStart;
    private boolean mRecStop;
    private boolean mRecPause;
    private final IDataBufferHolder mLastBufferHolder;
    private final IDocumentIOFactory mDocIOFactory = new TheTextDocIOFactory();
    private int mIsModified = 0;
    private final File mFile;
    private int mSampleCount;
    private final IContext mContext;
    private boolean mReadOnly = true;
    private ThermoResult mLastRecord;

    public DefaultMainDocument(IContext context, File file2) {
        this.mContext = context;
        this.mFile = file2;
        this.mSettings = new DefaultSettings(context);
        this.mLastBufferHolder = new DefaultDataBufferHolder(true);
    }

    @Override
    public File getFile() {
        return this.mFile;
    }

    @Override
    public boolean save() {
        if (this.mReadOnly) {
            return false;
        }
        IDataBuffer buff = this.getLastDataBuffer();
        if (buff != null) {
            buff.save();
        }
        if (!this.isModified()) {
            return false;
        }
        File file2 = this.getFile();
        IDocumentIO io = this.getDocIOFactory().newIO();
        IDocumentIO.MainDocData mdd = new IDocumentIO.MainDocData();
        ArrayList<File> fl = new ArrayList<File>();
        List<ISubDoc> sdl = this.mSubDocList;
        for (ISubDoc sd : sdl) {
            fl.add(sd.getFile());
        }
        mdd.subDocList = fl;
        mdd.mainDoc = this.getFile();
        IDocSettings sett = this.getSettings();
        mdd.sampleRate = sett.getSampleRate();
        mdd.alarmH = sett.getHighAlarm();
        mdd.alarmL = sett.getLowAlarm();
        mdd.unit = sett.getUnit();
        boolean rlt = io.save(file2, mdd);
        if (rlt) {
            this.setModified(false);
        }
        return rlt;
    }

    @Override
    public boolean load() {
        IDocumentIO io = this.getDocIOFactory().newIO();
        IDocumentIO.MainDocData mdd = io.loadMain(this.getFile());
        if (mdd == null) {
            return false;
        }
        Vector<DefaultSubDocument> list = new Vector<DefaultSubDocument>();
        List<File> srcList = mdd.subDocList;
        for (File file2 : srcList) {
            DefaultSubDocument sd = new DefaultSubDocument(this.mContext, this, list.size(), file2);
            list.add(sd);
        }
        this.mSubDocList.clear();
        this.mSubDocList.addAll(list);
        this.mIsModified = list.size();
        IDocSettings sett = this.getSettings();
        sett.setSampleRate(mdd.sampleRate);
        sett.setHighAlarm(mdd.alarmH);
        sett.setLowAlarm(mdd.alarmL);
        sett.setUnit(mdd.unit);
        return true;
    }

    @Override
    public IDocSettings getSettings() {
        return this.mSettings;
    }

    @Override
    public boolean create() {
        this.addSubDoc();
        return true;
    }

    @Override
    public void start() {
        this.mRecStart = true;
    }

    @Override
    public void pause() {
        this.mRecPause = true;
    }

    @Override
    public void resume() {
        this.mRecPause = false;
    }

    @Override
    public void stop() {
        this.mRecStop = true;
        IDataBuffer buff = this.getLastDataBuffer();
        if (buff != null) {
            buff.save();
        }
    }

    @Override
    public boolean appendRecord(ThermoResult result) {
        if (!this.mRecStart || this.mRecStop || this.mRecPause) {
            return false;
        }
        SampleRate rate = this.getSettings().getSampleRate();
        long lastTime = 0L;
        long thisTime = result.getTimestamp().milliseconds();
        if (this.mLastRecord != null) {
            lastTime = this.mLastRecord.getTimestamp().milliseconds();
        }
        if (lastTime <= thisTime && thisTime < lastTime + (long)rate.getValue() - 250L) {
            return false;
        }
        TemperatureUnit unit = this.getSettings().getUnit();
        Temperature temp = result.getTemperature();
        Timestamp time = result.getTimestamp();
        int index = this.mSampleCount++;
        result = new DefaultThermoResult(index, time, unit.convert(temp));
        IDataBuffer buffer = this.getLastDataBuffer();
        if (buffer != null && buffer.isFull()) {
            this.addSubDoc();
            this.save();
        }
        buffer = this.getLastDataBuffer();
        buffer.append(result);
        this.mLastRecord = result;
        return true;
    }

    @Override
    public IDataBuffer getLastDataBuffer() {
        IDataBuffer buff = this.mLastBufferHolder.getCurrent();
        if (buff == null) {
            ISubDoc sd = this.getLastSubDoc();
            buff = sd.newBuffer();
            this.mLastBufferHolder.setCurrent(buff);
        }
        return buff;
    }

    @Override
    public int countSubDoc() {
        return this.mSubDocList.size();
    }

    @Override
    public ISubDoc getSubDoc(int index) {
        return this.mSubDocList.get(index);
    }

    @Override
    public ISubDoc getLastSubDoc() {
        return this.mSubDocList.get(this.mSubDocList.size() - 1);
    }

    @Override
    public ISubDoc addSubDoc() {
        DefaultSubDocument sd = new DefaultSubDocument(this.mContext, this);
        this.mSubDocList.add(sd);
        this.mLastBufferHolder.setCurrent(sd.newBuffer());
        return sd;
    }

    @Override
    public IDocumentIOFactory getDocIOFactory() {
        return this.mDocIOFactory;
    }

    @Override
    public void setModified(boolean modified) {
        this.mIsModified = modified ? -1 : this.mSubDocList.size();
    }

    @Override
    public boolean isModified() {
        return this.mIsModified != this.mSubDocList.size();
    }

    @Override
    public IDataBufferHolder lastBufferHolder() {
        return this.mLastBufferHolder;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.mReadOnly = readonly;
    }

    @Override
    public boolean isReadonly() {
        return this.mReadOnly;
    }
}

