/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.Irth;
import ananas.cust.app.ir_therm.core.DefaultColorStyle;
import ananas.cust.app.ir_therm.core.DefaultMainDocument;
import ananas.cust.app.ir_therm.core.IColorStyle;
import ananas.cust.app.ir_therm.core.IDataBuffer;
import ananas.cust.app.ir_therm.core.IDataCenter;
import ananas.cust.app.ir_therm.core.IMainDoc;
import ananas.cust.app.ir_therm.core.ISubDoc;
import ananas.cust.app.ir_therm.core.IThermo;
import ananas.cust.app.ir_therm.core.SafeThermoFactory;
import ananas.cust.app.ir_therm.core.SampleRate;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timezone;
import ananas.cust.app.ir_therm.event.DefaultEventDispatcher;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventDispatcher2;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.event.ThermoResultEvent;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class DefaultDataCenter
implements IDataCenter {
    private final IEventDispatcher2 mEvtDisp = new DefaultEventDispatcher();
    private final IThermo mThermo;
    private final IColorStyle mColorStyle;
    private IMainDoc mDoc;
    private ISubDoc mCurSubDoc;
    private ISubDoc m_lastSubDoc;
    private IDataBuffer mCurBuffer;
    private TemperatureUnit mUnit = TemperatureUnit.unit_c;
    private Timezone mTimezone = Timezone.getLocalZone();

    public DefaultDataCenter() {
        this.mThermo = this._newThermo();
        this.mColorStyle = new DefaultColorStyle(this);
        this.mEvtDisp.addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent event) {
                DefaultDataCenter.this._onEvent(event);
            }
        });
        this._setDefaultMainDoc();
    }

    private void _setDefaultMainDoc() {
        File wkdir = Irth.getWorkingDirectory();
        File file2 = new File(wkdir, "nulldoc.txt");
        DefaultMainDocument doc = new DefaultMainDocument(this, file2);
        doc.addSubDoc();
        doc.setReadonly(true);
        this.setMainDoc(doc);
    }

    private void _onEvent(IEvent event) {
        if (event != null) {
            if (event instanceof ModelChangedEvent) {
                ModelChangedEvent e = (ModelChangedEvent)event;
                this._onModelEvent(e);
            } else if (event instanceof ThermoResultEvent) {
                ThermoResultEvent tre = (ThermoResultEvent)event;
                this._onThermoEvent(tre);
            }
        }
    }

    private void _onModelEvent(ModelChangedEvent e) {
        if (e.mask != 0 && (e.mask & 0x10) != 0) {
            this._doDataReset();
        }
    }

    private void _doDataReset() {
        IMainDoc md = this.mDoc;
        if (md != null) {
            SampleRate rate = md.getSettings().getSampleRate();
            this.mThermo.setSampleRate(rate);
        }
    }

    private IThermo _newThermo() {
        SafeThermoFactory factory = new SafeThermoFactory();
        IThermo thermo = factory.newThermo(this);
        return thermo;
    }

    private void _onThermoEvent(ThermoResultEvent tre) {
        IDataBuffer buf;
        ISubDoc doc2;
        ISubDoc doc1;
        ThermoResult rlt = tre.result;
        IMainDoc mainDoc = this.mDoc;
        if (mainDoc == null) {
            return;
        }
        if (!mainDoc.appendRecord(rlt)) {
            return;
        }
        this.getEventDispatcher().dispatchEvent(new ModelChangedEvent(this, 8));
        if (mainDoc.getSettings().autoScroll() && (doc1 = this.getCurrentSubDoc()) != (doc2 = (buf = mainDoc.getLastDataBuffer()) != null ? buf.getSubDocument() : null)) {
            this.setCurrentSubDoc(doc2);
        }
        this._checkLastSubDoc();
    }

    private void _checkLastSubDoc() {
        ISubDoc doc1 = this.m_lastSubDoc;
        ISubDoc doc2 = null;
        IMainDoc mdoc = this.getMainDoc();
        if (mdoc != null) {
            doc2 = mdoc.getLastSubDoc();
        }
        if (doc1 != doc2) {
            this.m_lastSubDoc = doc2;
            this.getEventDispatcher().dispatchEvent(new ModelChangedEvent(this, 16));
        }
    }

    @Override
    public IThermo getThermo() {
        return this.mThermo;
    }

    @Override
    public IMainDoc getMainDoc() {
        return this.mDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMainDoc(IMainDoc pnew) {
        IMainDoc pold;
        DefaultDataCenter defaultDataCenter = this;
        synchronized (defaultDataCenter) {
            pold = this.mDoc;
            this.mDoc = pnew;
        }
        if (pold != null) {
            pold.save();
        }
        if (pnew != null) {
            IDataBuffer buff = pnew.getLastDataBuffer();
            if (buff != null) {
                this.setCurrentSubDoc(buff.getSubDocument());
            }
            this.mUnit = pnew.getSettings().getUnit();
            this.fireModelDataReset();
            this.fireModelSettingsChanged();
            this.fireModelInfoChanged();
        }
    }

    @Override
    public IMainDoc openDoc(File file2) {
        DefaultMainDocument doc = new DefaultMainDocument(this, file2);
        doc.load();
        return doc;
    }

    @Override
    public IMainDoc newDoc(File file2) {
        DefaultMainDocument doc = new DefaultMainDocument(this, file2);
        doc.create();
        doc.save();
        return doc;
    }

    @Override
    public ISubDoc getCurrentSubDoc() {
        ISubDoc sd = this.mCurSubDoc;
        if (sd == null) {
            IMainDoc doc = this.mDoc;
            if (doc == null) {
                return null;
            }
            sd = doc.getLastSubDoc();
        }
        return sd;
    }

    @Override
    public void setCurrentSubDoc(ISubDoc doc) {
        this.mCurSubDoc = doc;
        this.getEventDispatcher().dispatchEvent(new ModelChangedEvent(this, 16));
    }

    @Override
    public IDataBuffer bufferForDoc(ISubDoc sd) {
        if (sd == null) {
            return null;
        }
        IMainDoc md = this.mDoc;
        if (md == null) {
            return null;
        }
        IDataBuffer buff = md.getLastDataBuffer();
        if (buff != null && sd.equals(buff.getSubDocument())) {
            return buff;
        }
        return sd.newBuffer();
    }

    @Override
    public IDataBuffer getCurrentBuffer() {
        IDataBuffer buff = this.mCurBuffer;
        if (buff != null && buff.getSubDocument() != this.mCurSubDoc) {
            buff = null;
        }
        if (buff == null) {
            this.mCurBuffer = buff = this.bufferForDoc(this.getCurrentSubDoc());
            ModelChangedEvent event = new ModelChangedEvent(this, 65535);
            this.mEvtDisp.dispatchEvent(event);
        }
        return buff;
    }

    @Override
    public IEventDispatcher2 getEventDispatcher() {
        return this.mEvtDisp;
    }

    @Override
    public TemperatureUnit getUnit() {
        TemperatureUnit unit = this.mUnit;
        if (unit == null) {
            IMainDoc md = this.mDoc;
            this.mUnit = md == null ? (unit = TemperatureUnit.unit_c) : (unit = md.getSettings().getUnit());
        }
        return unit;
    }

    @Override
    public Timezone getTimezone() {
        return this.mTimezone;
    }

    @Override
    public void fireModelDataReset() {
        ModelChangedEvent event = new ModelChangedEvent(this, 16);
        this.mEvtDisp.dispatchEvent(event);
    }

    @Override
    public void fireModelDataUpdate() {
        ModelChangedEvent event = new ModelChangedEvent(this, 8);
        this.mEvtDisp.dispatchEvent(event);
    }

    @Override
    public void fireModelSettingsChanged() {
        ModelChangedEvent event = new ModelChangedEvent(this, 1);
        this.mEvtDisp.dispatchEvent(event);
    }

    @Override
    public void fireModelInfoChanged() {
        ModelChangedEvent event = new ModelChangedEvent(this, 2);
        this.mEvtDisp.dispatchEvent(event);
    }

    @Override
    public void setUnit(TemperatureUnit unit) {
        this.mUnit = unit;
        this.fireModelDataReset();
    }

    @Override
    public IColorStyle getColorStyle() {
        return this.mColorStyle;
    }

    @Override
    public boolean saveAppSettings() {
        try {
            MyAppSettingsIO sett = new MyAppSettingsIO();
            return sett.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadAppSettings() {
        try {
            MyAppSettingsIO sett = new MyAppSettingsIO();
            return sett.load();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void onClose() {
        this.setMainDoc(null);
        this.getThermo().stop();
        this.saveAppSettings();
        int i = 4;
        while (i > 0) {
            System.out.println("$EXIT$");
            --i;
        }
        System.out.write(0);
        System.out.flush();
        System.err.write(0);
        System.err.flush();
    }

    class MyAppSettingsIO {
        static final String field_bg_color = "bgColor";
        static final String field_fg_color = "fgColor";
        static final String field_ah_color = "ahColor";
        static final String field_al_color = "alColor";
        static final String field_visible_cross = "visiblCross";
        static final String field_visible_grid_x = "visiblGridX";
        static final String field_visible_grid_y = "visiblGridY";

        MyAppSettingsIO() {
        }

        private File _getAppSettingsFile() {
            return new File(Irth.getWorkingDirectory(), "app.ini");
        }

        public boolean load() throws IOException {
            Properties prop = new Properties();
            if (this.__load(prop)) {
                IColorStyle cs = DefaultDataCenter.this.getColorStyle();
                cs.setLineBgColor(this._stringToColor(prop.getProperty(field_bg_color)));
                cs.setLineFgColor(this._stringToColor(prop.getProperty(field_fg_color)));
                cs.setHighAlarmColor(this._stringToColor(prop.getProperty(field_ah_color)));
                cs.setLowAlarmColor(this._stringToColor(prop.getProperty(field_al_color)));
                cs.setVisibleGridX(this._stringToBool(prop.getProperty(field_visible_grid_x)));
                cs.setVisibleGridY(this._stringToBool(prop.getProperty(field_visible_grid_y)));
                cs.setVisibleCursorCross(this._stringToBool(prop.getProperty(field_visible_cross)));
            }
            return true;
        }

        private boolean _stringToBool(String str) {
            return "yes".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str) || "1".equalsIgnoreCase(str);
        }

        private Color _stringToColor(String s) {
            int n = Integer.parseInt(s);
            return new Color(n);
        }

        private boolean __load(Properties prop) throws IOException {
            File file2 = this._getAppSettingsFile();
            if (!file2.exists()) {
                return false;
            }
            FileInputStream in = new FileInputStream(file2);
            prop.load(in);
            in.close();
            return true;
        }

        public boolean save() throws IOException {
            Properties prop = new Properties();
            IColorStyle cs = DefaultDataCenter.this.getColorStyle();
            prop.setProperty(field_bg_color, this._colorToString(cs.getLineBgColor()));
            prop.setProperty(field_fg_color, this._colorToString(cs.getLineFgColor()));
            prop.setProperty(field_al_color, this._colorToString(cs.getLowAlarmColor()));
            prop.setProperty(field_ah_color, this._colorToString(cs.getHighAlarmColor()));
            prop.setProperty(field_visible_cross, this._boolToString(cs.isVisibleCursorCross()));
            prop.setProperty(field_visible_grid_x, this._boolToString(cs.isVisibleGridX()));
            prop.setProperty(field_visible_grid_y, this._boolToString(cs.isVisibleGridY()));
            this._save(prop);
            return true;
        }

        private String _boolToString(boolean bool) {
            return "" + bool;
        }

        private String _colorToString(Color color) {
            int n = color.getRGB();
            return String.valueOf(n);
        }

        private void _save(Properties prop) throws IOException {
            File file2 = this._getAppSettingsFile();
            FileOutputStream out = new FileOutputStream(file2);
            prop.store(out, "comments");
            out.close();
        }
    }
}

