/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.core.DefaultXlsDocIOFactory;
import ananas.cust.app.ir_therm.core.IContext;
import ananas.cust.app.ir_therm.core.IDataBuffer;
import ananas.cust.app.ir_therm.core.IDocSettings;
import ananas.cust.app.ir_therm.core.IDocumentIO;
import ananas.cust.app.ir_therm.core.IDocumentIOFactory;
import ananas.cust.app.ir_therm.core.ISubDoc;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DefaultDataBuffer
implements IDataBuffer {
    private final ISubDoc mSubDoc;
    private final List<ThermoResult> mItems;
    private boolean mIsModified;
    private final int mCap;
    private final IContext mContext;
    private ThermoResult mMax;
    private ThermoResult mMin;
    private Timestamp mStartTime;
    private Timestamp mEndTime;
    private Temperature mAverage;
    private double mAverageSigma = 0.0;
    private int mAverageCount = 0;

    public DefaultDataBuffer(IContext context, ISubDoc doc) {
        this.mSubDoc = doc;
        this.mItems = new ArrayList<ThermoResult>();
        this.mContext = context;
        this.mCap = doc.getMainDocument().getSettings().getBufferCap();
    }

    @Override
    public File getFile() {
        return this.mSubDoc.getFile();
    }

    @Override
    public boolean save() {
        if (this.getSubDocument().getMainDocument().isReadonly()) {
            return false;
        }
        if (!this.mIsModified) {
            return false;
        }
        File file2 = this.getFile();
        DefaultXlsDocIOFactory xls_factory = new DefaultXlsDocIOFactory();
        IDocumentIOFactory factory = this.getSubDocument().getMainDocument().getDocIOFactory();
        IDocumentIO io = factory.newIO();
        IDocumentIO xls_io = xls_factory.newIO();
        IDocumentIO.SubDocData sdd = new IDocumentIO.SubDocData();
        sdd.sampleList = this.mItems;
        IDocSettings settings = this.getSubDocument().getMainDocument().getSettings();
        sdd.unit = settings.getUnit();
        sdd.alarmL = settings.getLowAlarm();
        sdd.alarmH = settings.getHighAlarm();
        sdd.sampleRate = settings.getSampleRate();
        xls_io.save(new File(String.valueOf(file2.getAbsolutePath()) + ".xls"), sdd);
        boolean rlt = io.save(file2, sdd);
        if (rlt) {
            this.mIsModified = false;
        }
        return rlt;
    }

    @Override
    public boolean load() {
        File file2 = this.getFile();
        IDocumentIOFactory factory = this.getSubDocument().getMainDocument().getDocIOFactory();
        IDocumentIO io = factory.newIO();
        IDocumentIO.SubDocData sdd = io.loadSub(file2);
        if (sdd == null) {
            return false;
        }
        this.mItems.clear();
        this.mItems.addAll(sdd.sampleList);
        TemperatureUnit unit = this.getSubDocument().getMainDocument().getSettings().getUnit();
        List<ThermoResult> list = sdd.sampleList;
        if (list.size() > 0) {
            double min;
            ThermoResult item0 = list.get(0);
            ThermoResult minRlt = null;
            ThermoResult maxRlt = null;
            double sigma = 0.0;
            double max = min = unit.convert(item0.getTemperature()).getValue();
            for (ThermoResult item : list) {
                Temperature temp = unit.convert(item.getTemperature());
                double value = temp.getValue();
                if (max < value) {
                    max = value;
                    maxRlt = item;
                }
                if (min > value) {
                    min = value;
                    minRlt = item;
                }
                sigma += value;
            }
            double average = sigma / (double)list.size();
            this.mAverageCount = list.size();
            this.mAverageSigma = sigma;
            this.mAverage = unit.objectForValue(average);
            this.mMax = maxRlt;
            this.mMin = minRlt;
            this.mEndTime = list.get(list.size() - 1).getTimestamp();
            this.mStartTime = item0.getTimestamp();
            this.mIsModified = false;
        }
        return true;
    }

    @Override
    public boolean create() {
        return false;
    }

    @Override
    public boolean append(ThermoResult item) {
        this.mItems.add(item);
        this._updateInfo(item);
        this.mIsModified = true;
        int mask = 10;
        this.mContext.getEventDispatcher().dispatchEvent(new ModelChangedEvent(this, mask));
        return true;
    }

    private void _updateInfo(ThermoResult item) {
        TemperatureUnit unit;
        Temperature curAver = this.mAverage;
        Temperature tempe = item.getTemperature();
        Timestamp time = item.getTimestamp();
        if (curAver != null) {
            unit = curAver.getUnit();
            tempe = unit.convert(tempe);
        } else {
            unit = tempe.getUnit();
        }
        if (this.mStartTime == null) {
            this.mStartTime = time;
        } else if (time.milliseconds() < this.mStartTime.milliseconds()) {
            this.mStartTime = time;
        }
        if (this.mEndTime == null) {
            this.mEndTime = time;
        } else if (time.milliseconds() > this.mEndTime.milliseconds()) {
            this.mEndTime = time;
        }
        if (this.mMin == null) {
            this.mMin = item;
        } else if (tempe.getValue() < this.mMin.getTemperature().getValue()) {
            this.mMin = item;
        }
        if (this.mMax == null) {
            this.mMax = item;
        } else if (tempe.getValue() > this.mMax.getTemperature().getValue()) {
            this.mMax = item;
        }
        this.mAverageSigma += tempe.getValue();
        ++this.mAverageCount;
        double value = this.mAverageSigma / (double)this.mAverageCount;
        this.mAverage = unit.objectForValue(value);
    }

    @Override
    public int count() {
        return this.mItems.size();
    }

    @Override
    public ThermoResult get(int index) {
        return this.mItems.get(index);
    }

    @Override
    public ThermoResult last() {
        int sz = this.mItems.size();
        if (sz <= 0) {
            return null;
        }
        return this.mItems.get(sz - 1);
    }

    @Override
    public Temperature average() {
        return this.mAverage;
    }

    @Override
    public ISubDoc getSubDocument() {
        return this.mSubDoc;
    }

    @Override
    public boolean isFull() {
        return this.mItems.size() >= this.mCap;
    }

    @Override
    public void setModified(boolean modified) {
        this.mIsModified = modified;
    }

    @Override
    public boolean isModified() {
        return this.mIsModified;
    }

    @Override
    public Timestamp startTime() {
        return this.mStartTime;
    }

    @Override
    public Timestamp endTime() {
        return this.mEndTime;
    }

    @Override
    public ThermoResult max() {
        return this.mMax;
    }

    @Override
    public ThermoResult min() {
        return this.mMin;
    }
}

