/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm;

import ananas.cust.app.ir_therm.core.Const;
import ananas.cust.app.ir_therm.core.SafeThermoFactory;
import ananas.cust.app.ir_therm.core.ShellThermoFactory;
import ananas.cust.app.ir_therm.gui.MainCtrl;
import ananas.cust.app.ir_therm.log.LogOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Main4IrTherm {
    public static void main(String[] arg) {
        System.setOut(new PrintStream(new LogOutputStream(System.out, "out")));
        System.setErr(new PrintStream(new LogOutputStream(System.err, "err")));
        System.out.println(Main4IrTherm.class + " - v11");
        ArgsParser ap = new ArgsParser();
        Properties prop = ap.parse(arg);
        try {
            SwingUtilities.invokeAndWait(new MyRunnable(prop));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class ArgsParser {
        ArgsParser() {
        }

        public Properties parse(String[] arg) {
            Properties prop = new Properties();
            String key = null;
            String value = null;
            String[] stringArray = arg;
            int n = arg.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.startsWith("-")) {
                    key = s;
                } else {
                    value = s;
                }
                if (key != null && value != null) {
                    prop.setProperty(key, value);
                    value = null;
                    key = null;
                }
                ++n2;
            }
            return prop;
        }
    }

    private static class MyRunnable
    implements Runnable {
        private final Properties mArg;

        public MyRunnable(Properties arg) {
            this.mArg = arg;
        }

        @Override
        public void run() {
            System.out.println(this.mArg);
            this._loadConst(this.mArg);
            MainCtrl mc = new MainCtrl();
            JFrame frame = mc.getFrame().getFrame();
            frame.setExtendedState(frame.getExtendedState() | 6);
            mc.getFrame().show();
        }

        private void _loadConst(Properties prop) {
            String drv = this.mArg.getProperty("-driver");
            Class drvCls = null;
            drvCls = drv == null ? ShellThermoFactory.class : this._classForName(drv);
            SafeThermoFactory.s_thermo_factory_class = drvCls;
            String str = this.mArg.getProperty("-sub-buffer-size");
            if (str != null) {
                Const.sub_buffer_size = Integer.parseInt(str);
            }
        }

        private Class<?> _classForName(String classname) {
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

